;*************************************************************************
;
;             PIC 16F84(A) - Logicanalyser .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 28.12.2004
;  Status    : A1.0                 Known Bugs : whew ...
;  Fuses     : XT enabled, WDT disabled and PWRTE enabled
;
;  Comments  : 1. An die 4 Speicherbaenke denken !!!!
;                 -Hex: 000-0FF, 100-1FF, 200-2FF, 300-3FF
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 |  Out | Parallel Load Output an alle 74HC165
; | Port A RA1 Pin 18 |  Out | Clock Output an alle 74HC165
; | Port A RA2 Pin 01 |  Out | Seriell Out nach RS232
; | Port A RA3 Pin 02 | In   | Trigger-Eingang zum Auslesestart
; | Port A RA4 Pin 03 | In   | nix
; |                   |      |
; | Port B RB0 Pin  6 | In   | Input von 74HC165 Nr. 1 SOUT           
; | Port B RB1 Pin  7 | In   | Input von 74HC165 Nr. 2 SOUT
; | Port B RB2 Pin  8 | In   | Input von 74HC165 Nr. 3 SOUT
; | Port B RB3 Pin  9 | In   | Input von 74HC165 Nr. 4 SOUT
; | Port B RB4 Pin 10 | In   | Input von 74HC165 Nr. 5 SOUT
; | Port B RB5 Pin 11 | In   | Input von 74HC165 Nr. 6 SOUT
; | Port B RB6 Pin 12 | In   | Input von 74HC165 Nr. 7 SOUT
; | Port B RB7 Pin 13 | In   | Input von 74HC165 Nr. 8 SOUT
;
; Oszillator :  10 Mhz -> 0.4 us pro Zyklus
;
; Bitdauer     1FH =   Zyklen fuer 52,08 Zyklen
; HalbBitdauer 0FH =   Zyklen fuer 26,04 Zyklen
;
; 19200 Baud, 8n1, direkt ueber MAX232 zu seriell
;
;*************************************************************************

	LIST    p=16F84  ; Prozessor definieren
	__config H'3DF9' ; Fuses definieren WDT off PWRT on CP off XT on

; Register Seite 1 definieren, da OPTION- und TRIS-Befehl abgekuendigt

ROPTION EQU     1       ; Options-Register
RTRISA  EQU     5       ; Ein/Ausgaenge Port A
RTRISB  EQU     6       ; Ein/Ausgaenge Port B

; Paar Flags definieren

RP1     EQU     6       ; Bank Flag im Status-Register
RP0     EQU     5       ; Bank Flag im Status-Register                                                       
RD      EQU     0       ; Start-Lesen im EECON1-Register
CARRY   EQU     0       ; Carry-Flag im Status-Register
ZER     EQU     2       ; Zero-Flag im Status-Register

; Definieren der RAM's
; 00 bis 0Bh sind fest zugeordneter Systemspeicher

TMR0            EQU     1       ; TMR0
PC              EQU     2       ; Programmcounter
STATUS          EQU     3       ; Statusregister
PORT_A          EQU     5       ; 4-BIT Port ( PA0 - PA3)
PORT_B          EQU     6       ; 8-BIT Port ( PB0 - PB8)
INTCON          EQU     0BH     ; Interruptsteuerregister
PCLATH          EQU     0AH     ; PC-Counter High Latch  

; Diese Bytes sind zur Steuerung des Internen EEPROMS

EEDATA          EQU     08      ; EEPROM Data Register
EEADR           EQU     09      ; EEPROM Adress Register
EECON1          EQU     08      ; EEPROM Control Register 1
EECON2          EQU     09      ; EEPROM Control Register 2

; Diese Bytes sind die Ram-Adressen fuer das Programm

OUTBYTE         EQU     0CH     ;
ABD             EQU     0DH     ;
ABE             EQU     0EH     ;
ABF             EQU     0FH     ;
ABG             EQU     10H     ;
COUNT           EQU     11H     ;
BITCNT          EQU     12H     ; Eingangsbyte
RAMOUT          EQU     13H     ; Ausgangsbyte
TMPA            EQU     14H     ; Temp A
TMPB            EQU     15H     ; Temp B
TMPC            EQU     16H     ; Temp C
TMPD            EQU     17H     ; Temp D
TMPX            EQU     18H     ; Temp E

;*************************************************************************
	
	ORG     0x000           ; Speicherstelle 00
	GOTO    RESVEK          ; Reset-Vektor
	
	ORG     0x004           ; Speicherstelle 04
	GOTO    RESVEK          ; Interrupt-Vektor

RESVEK  BSF     STATUS,RP0      ; Bank 1 anwaehlen
	MOVLW   B'11111000'     ; RA0..RA2 Ausgang, RA3..RA4 Eingang
	MOVWF   RTRISA          ; 
	MOVLW   B'11111111'     ; RB7-RB0 Eingang
	MOVWF   RTRISB          ; 
	MOVLW   B'00000000'     ; kein Vorteiler u.s.w.
	MOVWF   ROPTION         ; 
	BCF     STATUS,RP0      ; Bank 0 auswaehlen
	MOVLW   B'11111111'     ; TIMER0 auf FF setzen
	MOVWF   TMR0            ; in TMR reinschreiben
	MOVLW   B'00000000'     ; 
	MOVWF   INTCON          ; Interrupts disablen
	NOP                     ; Hier endet der Init-Vorgang
	BSF     PORT_A,0        ; Parallel Load auf 1
	BCF     PORT_A,1        ; Clock Line auf 0
	BSF     PORT_A,2        ; Serielle Leitung auf 1

;*************************************************************************
; START - Starteinstellungen
;*************************************************************************

START   MOVLW   D'042'          ; Stern 
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Byte wegschicken
  
	BCF     PORT_A,0        ; Parallel Load auf 0
	CALL    DELAYF          ; 50us warten
	BSF     PORT_A,0        ; Parallel load auf 1
	
	MOVLW   08H             ; Anzahl Abfragen - 7
	MOVWF   TMPA            ; TMPA Abfragecounter

ABFRG   MOVF    PORT_B,0        ; Alle Leitungen nach W
	MOVWF   TMPB            ; in TMPB sind nun alle Leitungen
	
	MOVLW   08H             ; 8 Bits auswerten        
	MOVWF   TMPC            ; TMPC ist der 8 Bit Counter

ENTSCH  RRF     TMPB,1          ; ein Bit ins Carry schieben
	BTFSC   STATUS,CARRY    ; 1 oder 0 ?
	GOTO    OUTHI           ; 1 Bit
OUTLO   MOVLW   D'048'          ; ASCII 0 in Ausgabe
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Ausgeben
	GOTO    WEITER3         ;
OUTHI   MOVLW   D'049'          ; ASCII 1 in Ausgabe
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Ausgeben
	GOTO    WEITER3         ;

WEITER3 DECFSZ  TMPC,1          ; TMPC 8 Bit Counter 0
	GOTO    ENTSCH          ; naechstes
	
	BSF     PORT_A,1        ; Clock-puls
	CALL    DELAYF          ;
	BCF     PORT_A,1        ;

	DECFSZ  TMPA,1          ; TMPA Abfragecounter 0 
	GOTO    ABFRG           ; naechstes 

	MOVLW   D'035'          ; Raute 
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Byte wegschicken

	MOVLW   H'0D'           ; Carriage Return 0D
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Byte wegschicken
	
	MOVLW   H'0A'           ; LineFeed 0A
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Byte wegschicken
	
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;
	CALL    DELAYF          ;


	GOTO    START           ; und nochmal

;*************************************************************************
; Routine sendet 8 Bit im seriellen Protokoll ab
; Eingang OUTBYTE
; Ausgang Port_A,2
; 19200 Baud bei 10MHz, 8 Datenbits, keine Paritaet, 1 Stop-Bit
;*************************************************************************

SENDB   MOVLW   08H             ; Anzahl Datenbits - 8
	MOVWF   BITCNT          ; nach Bitcnt
	BCF     PORT_A,2        ; Start-Bit auf 0
	CALL    DELAYF          ; eine Bit-Zeit warten

TXBT    RRF     OUTBYTE,1       ; ein Bit ins Carry schieben
	BTFSC   STATUS,CARRY    ; 1 oder 0 ?
	GOTO    ISHI            ; 1 Bit
ISLO    BCF     PORT_A,2        ; 0 Bit senden
	CALL    DELAYF          ; eine Bit-Zeit warten
	GOTO    ROTAT           ;
ISHI    BSF     PORT_A,2        ; 1 Bit senden
	CALL    DELAYF          ; eine Bit-Zeit warten
	GOTO    ROTAT           ;

ROTAT   DECFSZ  BITCNT,1        ; eins weggesendet ...
	GOTO    TXBT            ; naechstes Bit holen

	BSF     PORT_A,2        ; Stop-Bit auf 1
	CALL    DELAYF          ; eine Bit-Zeit warten
	BSF     PORT_A,2        ; Stop-Bit auf 1    
	CALL    DELAYF          ; eine Bit-Zeit warten
	RETURN                  ; zurueck zur Routine

;*************************************************************************
; Eine Zeitdauer von einem Bit warten 52,08 us
; Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
; + 4 pro Loop -> (4*X)+8 Zyklen
;*************************************************************************

DELAYF  MOVLW   01DH            ; Bitdelay nach W
	MOVWF   TMPX            ; nach TMPX
LOOP1   NOP                     ; nix tun
	DECFSZ  TMPX,1          ; eins weg ...
	GOTO    LOOP1           ; noch groesser Null
	RETURN

;*************************************************************************
; Eine Zeitdauer von einem halben Bit warten 26,04 us
; Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
; + 4 pro Loop -> (4*X)+8 Zyklen
;*************************************************************************

DELAYH  MOVLW   00FH            ; HalfBitDelay nach W
	MOVWF   TMPX            ; nach TMPX
LOOP2   NOP                     ; nix tun
	DECFSZ  TMPX,1          ; eins weg ...
	GOTO    LOOP2           ; noch groesser Null
	RETURN

	END                     ; das wars dann
