	list n=78, p=PIC16C84, r=HEX
	TITLE "M1R10-Konverter"

;*************************************************************************
;
;             PIC 16C84 SMD - M1R10-Konverter .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 30.01.1997
;  Status    : A0.0010              Known Bugs : whew ...
;  Fuses     : XT enabled, WDT disabled and PWRTE disabled
;
;  Comments  : -
;              -
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 |  Out | Ausgang zum M1 TXD
; | Port A RA1 Pin 18 |  Out | Ausgang zum R10 RXD
; | Port A RA2 Pin 01 |  Out | Ausgang zum ARM-Taster
; | Port A RA3 Pin 02 |  -   | -
; |                   |      |
; | Port B RB0 Pin  6 | In   | Eingang LED vom Display (Freq. Stored)
; | Port B RB1 Pin  7 | In   | Eingang Filter-Schalter
; | Port B RB2 Pin  8 | In   | Eingang Capture-Schalter
; | Port B RB3 Pin  9 | In   | Eingang fuer M1-Daten RXD
; | Port B RB4 Pin 10 | In   | -
; | Port B RB5 Pin 11 | In   | -
; | Port B RB6 Pin 12 | In   | -
; | Port B RB7 Pin 13 | In   | -
;
; M1 auf 4800 8n1 / R10 auf 4800 8n1
;
; Oszillator :  10 (8) Mhz -> 0.4 (0.5) us pro Zyklus
;
; Bitdauer     80H(64H) =  128(100) Zyklen fuer 208 us/520 Z. (208 us/416 Z.)
; HalbBitdauer 40H(32H) =  64(50) Zyklen fuer 104 us/260 Z. (104 us/208 Z.)
;
;*************************************************************************

; Paar Flags definieren

	RP1     EQU     6       ; Bank Flag im Status-Register
	RP0     EQU     5       ; Bank Flag im Status-Register                                                       
	RD      EQU     0       ; Start-Lesen im EECON1-Register
	CARRY   EQU     0       ; Carry-Flag im Status-Register
	ZER    EQU     2       ; ZER-Flag im Status-Register

;Definieren der RAM's
;00 bis 0Bh sind fest zugeordneter Systemspeicher

RTCC            EQU     1       ; RTCC
PC              EQU     2       ; Programmcounter
STATUS          EQU     3       ; Statusregister
PORT_A          EQU     5       ; 4-BIT Port ( PA0 - PA3)
PORT_B          EQU     6       ; 8-BIT Port ( PB0 - PB8)
INTCON          EQU     0BH     ; Interruptsteuerregister
PCLATH          EQU     0AH     ; PC-Counter High Latch  

; Diese Bytes sind zur Steuerung des Internen EEPROMS

EEDATA          EQU     08     ; EEPROM Data Register
EEADR           EQU     09     ; EEPROM Adress Register
EECON1          EQU     08     ; EEPROM Control Register 1
EECON2          EQU     09     ; EEPROM Control Register 2

; Diese Bytes sind die Ram-Adressen fuer das Programm

BYTECNT         EQU     0CH     ; Zaehler um 11 Byte holen/ausgeben
BITCNT          EQU     0DH     ; Zaehler um 8 Bit holen/ausgeben
TMPA            EQU     0EH     ;
TMPB            EQU     0FH     ;
TMPC            EQU     10H     ;
TMPD            EQU     11H     ;
TMP12           EQU     12H     ;
TMP13           EQU     13H     ;
TMP14           EQU     14H     ;
TMP15           EQU     15H     ;
TMP16           EQU     16H     ;
TMP17           EQU     17H     ;
TMP18           EQU     18H     ;
TMP19           EQU     19H     ;
TMP1A           EQU     1AH     ;
TMP1B           EQU     1BH     ;
TMP1C           EQU     1CH     ;
TMP1D           EQU     1DH     ;
TMP1E           EQU     1EH     ;
TMP1F           EQU     1FH     ;
RXSP1           EQU     20H     ; RX-Speicher 1
RXSP2           EQU     21H     ; RX-Speicher 2
RXSP3           EQU     22H     ; RX-Speicher 3
RXSP4           EQU     23H     ; RX-Speicher 4
RXSP5           EQU     24H     ; RX-Speicher 5
RXSP6           EQU     25H     ; RX-Speicher 6
RXSP7           EQU     26H     ; RX-Speicher 7
RXSP8           EQU     27H     ; RX-Speicher 8
TXSP1           EQU     28H     ; TX-Speicher 1
TXSP2           EQU     29H     ; TX-Speicher 2
TXSP3           EQU     2AH     ; TX-Speicher 3
TXSP4           EQU     2BH     ; TX-Speicher 4
TMP2C           EQU     2CH     ;
TMP2D           EQU     2DH     ;
TMP2E           EQU     2EH     ;
TMP2F           EQU     2FH     ;

; Vereinbarung beim Programmieren :

	TXM1    EQU     0       ; Ausgang M1-Daten
	TXR10   EQU     1       ; Ausgang R10-Daten
	ARM     EQU     2       ; Ausgang ARM-Taster

	LED     EQU     0       ; Eingang fuer LED vom Display (Freq.Stored)
	FIL     EQU     1       ; Eingang Filter-Schalter
	CAP     EQU     2       ; Eingang Capture-Schalter
	RXM1    EQU     3       ; Eingang M1-Daten


;*************************************************************************
	
	ORG     0x000           ; Speicherseite 00
	GOTO    RESVEK          ; Reset-Vektor

RESVEK  MOVLW   B'11110000'     ; RA0..RA3 Ausgaenge
	TRIS    PORT_A          ;

	MOVLW   B'11111111'     ; RB0..RB7 Eingaenge
	TRIS    PORT_B          ;

	CLRWDT                  ; Watchdog Timer zuruecksetzen
	MOVLW   B'00000000'     ; kein Vorteiler
	OPTION                  ;

	MOVLW   B'00000000'     ; RTCC-INT disable
	MOVWF   INTCON          ;

;*************************************************************************

; Alle Variablen lschen

START   BSF     PORT_A,TXM1     ; TXM1 auf 1
	BSF     PORT_A,TXR10    ; TXR10 auf 1
	BSF     PORT_A,ARM      ; ARM auf 1
	CLRF    BYTECNT         ; Byte-Zhler auf 0
	CLRF    BITCNT          ; Bit-Zhler auf 0
	CLRF    RXSP1           ; RXSpeicher 1 auf 0 
	CLRF    RXSP2           ; RXSpeicher 2 auf 0 
	CLRF    RXSP3           ; RXSpeicher 3 auf 0 
	CLRF    RXSP4           ; RXSpeicher 4 auf 0 
	CLRF    RXSP5           ; RXSpeicher 5 auf 0 
	CLRF    RXSP6           ; RXSpeicher 6 auf 0 
	CLRF    RXSP7           ; RXSpeicher 7 auf 0 
	CLRF    RXSP8           ; RXSpeicher 8 auf 0
	CLRF    TXSP1           ; TXSpeicher 1 auf 0
	CLRF    TXSP2           ; TXSpeicher 2 auf 0
	CLRF    TXSP3           ; TXSpeicher 3 auf 0
	CLRF    TXSP4           ; TXSpeicher 4 auf 0

;**************************************************************************
;****   Warten auf das Startsignal                                     ****
;**************************************************************************

	BTFSC   PORT_B,FIL      ; ist Filter auf 0 ?
	GOTO    START           ; zurueck zum Start
	BTFSC   PORT_B,CAP      ; ist Capture auf 0 ?
	GOTO    CAPOFF          ; Capture auf off
	GOTO    START           ; Capture auf on - nicht beachten

CAPOFF  BTFSC   PORT_B,FIL      ; ist Filter auf 0 ?
	GOTO    START           ; zurueck zum Start
	BTFSS   PORT_B,CAP      ; ist Capture auf 1 ?
	GOTO    START           ; Capture auf on
	BTFSC   PORT_B,LED      ; LED an ? (Signal inv. !)
	GOTO    CAPOFF          ; wieder zurueck
CAPOFF1 BTFSS   PORT_B,LED      ; LED wieder aus ? (Signal inv.!)
	GOTO    CAPOFF1         ; warten
	CALL    SEND13          ; 13hex aussenden
	GOTO    RXDAT           ; Daten holen

;**************************************************************************
;****   Empfangen der Daten                                            ****
;**************************************************************************

RXDAT  MOVLW    0Bh             ; 11 nach W 
       MOVWF    BYTECNT         ; W nach BYTECNT
RXSPAC CALL     GETBY           ; 1 Byte holen
       DECF     BYTECNT,1       ; vom Counter 1 abziehen
       MOVLW    20h             ; SPACE nach W
       XORWF    TMPD,0          ; Vergleichen
       BTFSC    STATUS,ZER     ; weiter zu RXW1
       GOTO     RXSPAC          ; SPACE erkannt
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP1           ; nach RXSPeicher 1

RXW1   CALL     GETBY           ; 1 Byte holen
       DECF     BYTECNT,1       ; vom Counter 1 abziehen
       MOVLW    2Eh             ; PUNKT nach W
       XORWF    TMPD,0          ; Vergleichen
       BTFSC    STATUS,ZER     ; 
       GOTO     RXDOT           ; PUNKT erkannt
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP2           ; nach RXSPeicher 2
       CALL     GETBY           ; 1 Byte holen
       DECF     BYTECNT,1       ; vom Counter 1 abziehen
       MOVLW    2Eh             ; PUNKT nach W
       XORWF    TMPD,0          ; Vergleichen
       BTFSC    STATUS,ZER     ; 
       GOTO     RXDOT           ; PUNKT erkannt
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP3           ; nach RXSPeicher 3
       CALL     GETBY           ; 1 Byte holen
       DECF     BYTECNT,1       ; vom Counter 1 abziehen
       MOVLW    2Eh             ; PUNKT nach W
       XORWF    TMPD,0          ; Vergleichen
       BTFSC    STATUS,ZER     ; 
       GOTO     RXDOT           ; PUNKT erkannt
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP4           ; nach RXSPeicher 4
RXW2   CALL     GETBY           ; 1 Byte holen
       DECF     BYTECNT,1       ; vom Counter 1 abziehen
       MOVLW    2Eh             ; PUNKT nach W
       XORWF    TMPD,0          ; Vergleichen
       BTFSC    STATUS,ZER     ; 
       GOTO     RXDOT           ; PUNKT erkannt
       GOTO     RXW2            ; weiter bis PUNKT kommt
   
RXDOT  CALL     GETBY           ; 1 Byte holen
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP5           ; nach RXSPeicher 5
       DECFSZ   BYTECNT,1       ; 1 abziehen
       GOTO     RXDOT2          ; weiter zu RXDOT2
       GOTO     DECOD           ; keine Zeichen mehr
RXDOT2 CALL     GETBY           ; 1 Byte holen
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP6           ; nach RXSPeicher 6
       DECFSZ   BYTECNT,1       ; 1 abziehen
       GOTO     RXDOT3          ; weiter zu RXDOT3  
       GOTO     DECOD           ; keine Zeichen mehr
RXDOT3 CALL     GETBY           ; 1 Byte holen
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP7           ; nach RXSPeicher 7
       DECFSZ   BYTECNT,1       ; 1 abziehen
       GOTO     RXDOT4          ; weiter zu RXDOT4  
       GOTO     DECOD           ; keine Zeichen mehr
RXDOT4 CALL     GETBY           ; 1 Byte holen
       MOVF     TMPD,0          ; TMPD nach W
       MOVWF    RXSP8           ; nach RXSPeicher 8
       DECFSZ   BYTECNT,1       ; 1 abziehen
       GOTO     DECOD           ; weiter zu DECOD  
       GOTO     DECOD           ; keine Zeichen mehr

;**************************************************************************
;****   Decodieren der empfangenen Daten                               ****
;**************************************************************************


DECOD   MOVLW   00h             ; 00h nach W
	XORWF   RXSP4,0         ; RXSpeicher 4 ist 0?
	BTFSS   STATUS,ZER     ; 
	GOTO    DECOD1          ; weiter bei DECOD1
	MOVF    RXSP3,0         ; RXSpeicher 3 nach W
	MOVWF   RXSP4           ; RXSpeicher 3 nach 4 kopieren
	MOVF    RXSP2,0         ; RXSpeicher 2 nach W
	MOVWF   RXSP3           ; RXSpeicher 2 nach 3 kopieren
	MOVF    RXSP1,0         ; RXSpeicher 1 nach W
	MOVWF   RXSP2           ; RXSpeicher 1 nach 2 kopieren
	MOVLW   00h             ; 00h nach W
	MOVWF   RXSP1           ; RXSpeicher 1 loeschen
	GOTO    DECOD           ; bei 0'ern Durchschieben

DECOD1  MOVLW   00h             ; 00h nach W
	XORWF   RXSP1,0         ; RXSpeicher 1 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    DECOD2          ; weiter bei DECOD1
	MOVLW   30h             ; 
	SUBWF   RXSP1,1         ; 30hex abziehen, in RXSPeicher 1
DECOD2  MOVLW   00h             ; 00h nach W
	XORWF   RXSP2,0         ; RXSpeicher 2 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    DECOD3          ; weiter bei DECOD1
	MOVLW   30h             ; 
	SUBWF   RXSP2,1         ; 30hex abziehen, in RXSPeicher 2
DECOD3  MOVLW   00h             ; 00h nach W
	XORWF   RXSP3,0         ; RXSpeicher 3 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    DECOD4          ; weiter bei DECOD1
	MOVLW   30h             ; 
	SUBWF   RXSP3,1         ; 30hex abziehen, in RXSPeicher 3
DECOD4  MOVLW   00h             ; 00h nach W
	XORWF   RXSP4,0         ; RXSpeicher 4 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    DECOD5          ; weiter bei DECOD1
	MOVLW   30h             ; 
	SUBWF   RXSP4,1         ; 30hex abziehen, in RXSPeicher 4
DECOD5  MOVLW   00h             ; 00h nach W
	XORWF   RXSP5,0         ; RXSpeicher 5 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    DECOD6          ; weiter bei DECOD1
	MOVLW   30h             ; 
	SUBWF   RXSP5,1         ; 30hex abziehen, in RXSPeicher 5
DECOD6  MOVLW   00h             ; 00h nach W
	XORWF   RXSP6,0         ; RXSpeicher 6 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    DECOD7          ; weiter bei DECOD1
	MOVLW   30h             ; 
	SUBWF   RXSP6,1         ; 30hex abziehen, in RXSPeicher 6
DECOD7  MOVLW   00h             ; 00h nach W
	XORWF   RXSP7,0         ; RXSpeicher 7 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    DECOD8          ; weiter bei DECOD1
	MOVLW   30h             ; 
	SUBWF   RXSP7,1         ; 30hex abziehen, in RXSPeicher 7
DECOD8  MOVLW   00h             ; 00h nach W
	XORWF   RXSP8,0         ; RXSpeicher 8 ist 0?
	BTFSC   STATUS,ZER     ; 
	GOTO    COPYBY          ; weiter zum Ausgabe-Speicher kopieren
	MOVLW   30h             ; 
	SUBWF   RXSP8,1         ; 30hex abziehen, in RXSPeicher 8
	GOTO    COPYBY          ; weiter zum Ausgabe-Speicher kopieren

COPYBY  SWAPF   RXSP1,0         ; High-Low tauschen, in W
	IORWF   RXSP2,0         ; mit Low zusammenfuegen
	MOVWF   TXSP4           ; nach TXSpeicher 4
	SWAPF   RXSP3,0         ; High-Low tauschen, in W
	IORWF   RXSP4,0         ; mit Low zusammenfuegen
	MOVWF   TXSP3           ; nach TXSpeicher 3
	SWAPF   RXSP5,0         ; High-Low tauschen, in W
	IORWF   RXSP6,0         ; mit Low zusammenfuegen
	MOVWF   TXSP2           ; nach TXSpeicher 2
	SWAPF   RXSP7,0         ; High-Low tauschen, in W
	IORWF   RXSP8,0         ; mit Low zusammenfuegen
	MOVWF   TXSP1           ; nach TXSpeicher 1
	GOTO    TRDAT           ; und aussenden !

	org     0x100           ; Speicherseite 01

;**************************************************************************
;****   Aussenden der Umgewandelten Daten                              ****
;**************************************************************************

TRDAT   MOVLW   H'FE'             ; FE nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVLW   H'FE'             ; FE nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVLW   00h             ; 00 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVLW   05h             ; 05 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVLW   00h             ; 00 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVLW   00h             ; 00 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVF    TXSP1,0         ; TXSpeicher 1 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVF    TXSP2,0         ; TXSpeicher 2 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVF    TXSP3,0         ; TXSpeicher 3 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVF    TXSP4,0         ; TXSpeicher 4 nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	MOVLW   H'FD'             ; FD nach W
	MOVWF   TMPD            ; nach TMPD
	CALL    SENDBY          ; aussenden
	GOTO    START           ; zurueck zum Start

;**************************************************************************
;****   Wichtige Unterroutinen :                                       ****
;**************************************************************************
;****   SENDBY, SEND13, GETBY, DELAYF, DELAYH                          ****
;**************************************************************************


;**************************************************************************
; Routine holt aus TMPD ein Byte und gibt 8 Bit mit Start und Stopbit auf
; Port_A TXR10 aus

SENDBY  BCF     PORT_A,TXR10    ; 0 fuer Startbit
	MOVLW   08H             ; W auf 8
	MOVWF   BITCNT          ; Bitcounter auf 8 legen
	CALL    DELAYF          ; volles Startbit abwarten

TXBY    BSF     STATUS,CARRY    ; Carry vorsichtshalber auf 1
	RRF     TMPD,1          ; nach links schieben Erg. in Carry
	BTFSS   STATUS,CARRY    ; Carry auf 1 ?
	GOTO    TX0             ; ne 0
	BSF     PORT_A,TXR10    ; eine 1 ausgeben
	CALL    DELAYF          ; volles Bit warten
	DECFSZ  BITCNT,1        ; Bitcnt -1
	GOTO    TXBY            ; noch ein Bit ausgeben
	GOTO    TXSTOP          ; zum Stopbit

TX0     BCF     PORT_A,TXR10    ; eine 0 ausgeben
	CALL    DELAYF          ; volles Bit warten
	DECFSZ  BITCNT,1        ; Bitcnt -1
	GOTO    TXBY            ; noch ein Bit ausgeben
	GOTO    TXSTOP          ; zum Stopbit

TXSTOP  BSF     PORT_A,TXR10    ; eine 1 ausgeben
	CALL    DELAYF          ; volles Bit warten
	RETURN                  ; zurueck zur aufrufenden Routine

;*************************************************************************
; Routine gibt 13hex mit 8 Bit , Start und Stopbit auf
; Port_A TXM1 aus

SEND13  MOVLW   0DH             ; 0Dhex in W
	MOVWF   TMPD            ; in TMPD speichern
	BCF     PORT_A,TXM1     ; 0 fuer Startbit
	MOVLW   08H             ; W auf 8
	MOVWF   BITCNT          ; Bitcounter auf 8 legen
	CALL    DELAYF          ; volles Startbit abwarten

TXBY13  BSF     STATUS,CARRY    ; Carry vorsichtshalber auf 1
	RRF     TMPD,1          ; nach links schieben Erg. in Carry
	BTFSS   STATUS,CARRY    ; Carry auf 1 ?
	GOTO    TX013           ; ne 0
	BSF     PORT_A,TXM1     ; eine 1 ausgeben
	CALL    DELAYF          ; volles Bit warten
	DECFSZ  BITCNT,1        ; Bitcnt -1
	GOTO    TXBY13          ; noch ein Bit ausgeben
	GOTO    TXST13          ; zum Stopbit

TX013   BCF     PORT_A,TXM1     ; eine 0 ausgeben
	CALL    DELAYF          ; volles Bit warten
	DECFSZ  BITCNT,1        ; Bitcnt -1
	GOTO    TXBY13          ; noch ein Bit ausgeben
	GOTO    TXST13          ; zum Stopbit

TXST13  BSF     PORT_A,TXM1     ; eine 1 ausgeben
	CALL    DELAYF          ; volles Bit warten
	RETURN                  ; zurueck zur aufrufenden Routine

;**************************************************************************
; Routine holt 8 Bit vom Port_B,RXM1 ab, und legt das Ergebnis-Byte in
; TMPD ab
;

GETBY   BTFSC   PORT_B,RXM1     ; kommt die erste Null ?
	GOTO    GETBY           ; nochmal probieren
	CALL    DELAYH          ; eine halbe Bitdauer warten

	BTFSC   PORT_B,RXM1     ; Startbit ok - noch da ?
	GOTO    GETBY           ; nochmal alles von vorn...

	MOVLW   08H             ; 8 Bits holen
	MOVWF   BITCNT          ; nach Bitcnt
	CLRF    TMPD            ; Empfangsbyte lschen

RXBT    CALL    DELAYF          ; ein Bit abwarten
	BTFSC   PORT_B,RXM1     ; Status des Bits
	GOTO    ISHI            ; 1 Bit
	BCF     STATUS,CARRY    ; 0 Bit
	GOTO    ROTAT           ; weitermachen beim Bit-Rotieren

ISHI    BSF     STATUS,CARRY    ; Carry auf 1 setzen
ROTAT   RRF     TMPD            ; per Carry ein Bit ins TMPD holen
	DECFSZ  BITCNT,1        ; eins weg...
	GOTO    RXBT            ; nchstes Bit holen

	CALL    DELAYF          ; Bitdauer wegen Stoppbit abwarten

	RETURN                  ; zurueck zur aufrufenden Routine

; Eine Zeitdauer von einem Bit warten 208 us
; Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
; + 4 pro Loop -> (4*X)+8 Zyklen

DELAYF  MOVLW   H'80'           ; Bitdelay nach W
	MOVWF   TMPA            ; nach TMPA
LOOP1   NOP                     ; nix tun
	DECFSZ  TMPA,1          ; eins weg ...
	GOTO    LOOP1           ; noch grer Null
	RETURN

; Eine Zeitdauer von einem halben Bit warten 104 us
; Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
; + 4 pro Loop -> (4*X)+8 Zyklen

DELAYH  MOVLW   H'40'           ; HalfBitDelay nach W
	MOVWF   TMPA            ; nach TMPA
LOOP2   NOP                     ; nix tun
	DECFSZ  TMPA,1          ; eins weg ...
	GOTO    LOOP2           ; noch grer Null
	RETURN

;*************************************************************************
;*************************************************************************

	END                     ; das wars dann
